require( "scripts/style.lua" );

SetState("StoryModeSessionTime",0);
SetState("MainMenuScreenTime",0);
SetState("ComicScreenTime",1);
SetState("MetaMapTime",0);
SetState("HelpScreenTime",0);

function SetScreen()
	if gComicMaxPage == 1 then
		EnableWindow("first",false);
		EnableWindow("middle",false);
		EnableWindow("last",false);
		if ( gComic == 6 ) then 
			EnableWindow("one",false);
			EnableWindow("final",true);
		else
			EnableWindow("one",true);
			EnableWindow("final",false);
		end
	elseif gComicPage == 1 then
		EnableWindow("first",true);
		EnableWindow("middle",false);
		EnableWindow("last",false);
		EnableWindow("one",false);
		EnableWindow("final",false);
	elseif gComicPage == gComicMaxPage then
		EnableWindow("first",false);
		EnableWindow("middle",false);
		EnableWindow("last",true);
		EnableWindow("one",false);
		EnableWindow("final",false);
	else
		EnableWindow("first",false);
		EnableWindow("middle",true);
		EnableWindow("last",false);
		EnableWindow("one",false);
		EnableWindow("final",false);
	end
end

------------------------------------------------------------------------------
function AddComicText()

	t = {};

	if ( gComic == 1 ) then
	
		if ( gComicPage == 1 ) then
		
			AddComicText_Aux( t, 603, 133, 128, 46, "comic_1_a" );
			AddComicText_Aux( t, 579, 186, 188, 64, "comic_1_b" );
			AddComicText_Aux( t, 570, 313, 175, 75, "comic_1_c" );
			AddComicText_Aux( t, 111, 443, 192, 77, "comic_1_d" );
			AddComicText_Aux( t, 525, 466, 192, 69, "comic_1_e" );
			AddComicText_Aux_Size( t, 2, 17, 178, 69, "comic_1_f", 23 );
			
		elseif ( gComicPage == 2 ) then
		
			AddComicText_Aux( t,  44,  74,  83,  43, "comic_2_a" );
			AddComicText_Aux( t, 128,  23, 122,  69, "comic_2_b" );
			AddComicText_Aux( t, 203,  85, 187, 114, "comic_2_c" );
			AddComicText_Aux( t, 355,   9, 155,  59, "comic_2_d" );
			AddComicText_Aux( t, 397,  96, 100,  58, "comic_2_e" );
			AddComicText_Aux( t, 606,   7, 179,  78, "comic_2_f" );
			AddComicText_Aux( t, 571, 181,  99,  38, "comic_2_g" );
			AddComicText_Aux( t,  17, 260, 169,  95, "comic_2_h" );
			AddComicText_Aux( t, 186, 324, 115,  62, "comic_2_i" );
			AddComicText_Aux( t, 263, 499, 117,  64, "comic_2_j" );
			AddComicText_Aux( t, 544, 286, 107,  62, "comic_2_k" );
		elseif ( gComicPage == 3 ) then
		
			AddComicText_Aux( t,  23,  22, 203,  86, "comic_3_a" );
			AddComicText_Aux( t,  67, 185, 105,  36, "comic_3_b" );
			AddComicText_Aux( t, 216,  67, 201, 112, "comic_3_c" );
			AddComicText_Aux( t, 367, 167, 134,  64, "comic_3_d" );
			AddComicText_Aux( t, 506, 144, 126, 104, "comic_3_e" );
			AddComicText_Aux( t, 668,  31,  70,  33, "comic_3_f" );
			AddComicText_Aux( t, 644, 148, 141,  99, "comic_3_g" );
			AddComicText_Aux( t, 532, 510, 103,  56, "comic_3_h" );
		end
	
	elseif ( gComic == 2 ) then
	
		AddComicText_Aux( t,  58,  14, 188,  94, "comic_4_a" );
		AddComicText_Aux( t, 260,  11, 152,  81, "comic_4_b" );
		AddComicText_Aux( t, 467,  25, 132,  74, "comic_4_c" );
		AddComicText_Aux( t, 660, 178, 104,  49, "comic_4_d" );
		AddComicText_Aux( t,  10, 293, 180,  90, "comic_4_e" );
		AddComicText_Aux( t, 381, 290, 130,  65, "comic_4_f" );
		AddComicText_Aux( t,  10, 426, 130,  50, "comic_4_g" );
		AddComicText_Aux( t, 241, 422, 106,  53, "comic_4_h" );
		AddComicText_Aux( t, 404, 500, 147,  81, "comic_4_i" );
		AddComicText_Aux( t, 543, 295, 140,  56, "comic_4_j" );
		AddComicText_Aux( t, 628, 503, 133,  69, "comic_4_k" );
	elseif ( gComic == 3 ) then
		AddComicText_Aux( t, 103,  16, 188,  94, "comic_5_a" );
		AddComicText_Aux( t, 355,  16, 152,  81, "comic_5_b" );
		AddComicText_Aux( t, 300,  202, 132,  74, "comic_5_c" );
		AddComicText_Aux( t, 522,  18, 132,  74, "comic_5_d" );
		AddComicText_Aux( t, 532, 157, 180,  90, "comic_5_e" );
		AddComicText_Aux( t, 667, 216, 130,  65, "comic_5_f" );
		AddComicText_Aux( t, 0, 289, 110,  50, "comic_5_g" );
		AddComicText_Aux( t, 10, 444, 150,  90, "comic_5_h" );
		AddComicText_Aux( t, 400, 272, 106,  90, "comic_5_i" );
		AddComicText_Aux( t, 300, 440, 106,  90, "comic_5_j" );
		AddComicText_Aux( t, 550, 272, 106,  90, "comic_5_k" );
		AddComicText_Aux( t, 610, 471, 130,  90, "comic_5_l" );
	elseif ( gComic == 4 ) then
		AddComicText_Aux( t, 173,  2, 188,  94, "comic_6_a" );
		AddComicText_Aux( t, 150,  150, 152,  81, "comic_6_b" );
		AddComicText_Aux( t, 355,  153, 132,  74, "comic_6_c" );
		AddComicText_Aux( t, 480,  0, 132,  70, "comic_6_d" );
		AddComicText_Aux( t, 555, 133, 210,  95, "comic_6_e" );
		AddComicText_Aux( t, 692, 75, 140,  65, "comic_6_f" );
		AddComicText_Aux( t, 0, 220, 90,  50, "comic_6_g" );
		AddComicText_Aux( t, 90, 218, 150,  90, "comic_6_h" );
		AddComicText_Aux( t, 160, 327, 150,  90, "comic_6_i" );
		AddComicText_Aux( t, 342, 220, 150,  150, "comic_6_j" );	
		AddComicText_Aux( t, 500, 210, 250,  90, "comic_6_k" );
		AddComicText_Aux( t, 495, 310, 106,  90, "comic_6_l" );
		AddComicText_Aux( t, 657, 240, 106,  90, "comic_6_m" );
		AddComicText_Aux( t, 393, 505, 135,  90, "comic_6_n" );
		AddComicText_Aux( t, 550, 505, 150,  90, "comic_6_o" );
	elseif (gComic == 5) then
		AddComicText_Aux( t, 30,  14, 188,  94, "comic_7_a" );
		AddComicText_Aux( t, 250,  5, 152,  81, "comic_7_b" );
		AddComicText_Aux( t, 250,  145, 132,  74, "comic_7_c" );
		AddComicText_Aux( t, 397,  27, 132,  70, "comic_7_d" );
		AddComicText_Aux( t, 410, 115, 200,  90, "comic_7_e" );
		AddComicText_Aux( t, 620, 60, 140,  65, "comic_7_f" );
		
		AddComicText_Aux( t, 30, 202, 150,  90, "comic_7_g" );
		AddComicText_Aux( t, 155, 255, 150,  90, "comic_7_h" );
		AddComicText_Aux( t, 310, 292, 150,  90, "comic_7_i" );
		
		AddComicText_Aux( t, 460, 172, 150,  150, "comic_7_j" );	
		AddComicText_Aux( t, 575, 290, 250,  90, "comic_7_k" );
		AddComicText_Aux( t, 23, 353, 150,  90, "comic_7_l" );
		AddComicText_Aux( t, 95, 458, 106,  90, "comic_7_m" );
		AddComicText_Aux_Size( t, 486, 492, 135,  90, "comic_7_n", 30);
	elseif (gComic == 6) then
		AddComicText_Aux( t, 173,  120, 188,  94, "comic_8_a" );
		AddComicText_Aux( t, 460,  10, 152,  81, "comic_8_b" );
		
		AddComicText_Aux( t, 365,  310, 132,  74, "comic_8_c" );
		AddComicText_Aux( t, 480,  197, 132,  74, "comic_8_c" );
		AddComicText_Aux( t, 620,  215, 132,  74, "comic_8_c" );


		AddComicText_Aux( t, 58,  385, 132,  70, "comic_8_d" );
		AddComicText_Aux( t, 245, 388, 200,  90, "comic_8_e" );
		AddComicText_Aux( t, 300, 525, 140,  65, "comic_8_f" );
		AddComicText_Aux( t, 628, 412, 130,  50, "comic_8_g" );	
	end
	
	return Group(t);
end
------------------------------------------------------------------------------
function AddComicText_Aux( aT, aX, aY, aW, aH, aLabel )
			
	table.insert( aT,
			Text{
					x		= aX,
					y 		= aY,
					w		= aW,
					h		= aH,
					flags 	= kHAlignCenter + kVAlignCenter,
					label   = aLabel,
					font	= { "fonts/doncomic.mvec", 16, BlackColor },
			}
		);
end

function AddComicText_Aux_Size( aT, aX, aY, aW, aH, aLabel, aSize)
			
	table.insert( aT,
			Text{
					x		= aX,
					y 		= aY,
					w		= aW,
					h		= aH,
					flags 	= kHAlignCenter + kVAlignCenter,
					label   = aLabel,
					font	= { "fonts/doncomic.mvec", aSize, BlackColor },
			}
		);
end
------------------------------------------------------------------------------
------------------------------------------------------------------------------


vComic_PrevButtonGraphics=
{
	"buttons/arrowleft_up.png",
	"buttons/arrowleft_down.png",
	"buttons/arrowleft_over.png",
}
vComic_NextButtonGraphics=
{
	"buttons/arrowleft_up.png",
	"buttons/arrowleft_down.png",
	"buttons/arrowleft_over.png",
}
vComic_SkipButtonGraphics=
{
	"buttons/btn_a_normal.png",
	"buttons/btn_a_down.png",
	"buttons/btn_a_over.png",
}
vComic_PlayButtonGraphics=
{
	"buttons/btn_a_normal.png",
	"buttons/btn_a_down.png",
	"buttons/btn_a_over.png",
}
vComic_LongButtonGraphics=
{
	"buttons/long_button_up.png",
	"buttons/long_button_down.png",
	"buttons/long_button_over.png",
}

vFontTypeComic = { standardFont, 16, BlackColor };


gBackground = "comics/comics_" .. gComic .. "_" .. gComicPage;

MakeDialog
{
	-- Name the modal dialog
	name = "Comics",
	Bitmap
	{
		name="backgroundimage",
		image=gBackground,

		Comic
		{
			x=kCenter,
			y=kCenter,
			w=kMax,
			h=kMax,
			name="first",
			SetStyle(ButtonStyle),
			Button
			{
				label 	= "skip",
				x		= kCenter, 
				y		= kMax-28,
				graphics= vComic_SkipButtonGraphics,
				font 	= vFontTypeComic,
				command	= function() 
					SwapToModal("scripts/loading.lua");
					--SwapToModal("scripts/metamap.lua"); 
				end;
			},
			SetStyle(ButtonStyle),
			Button
			{
				--label 	= "next",
				x		= kMax-34,
				y		= kMax-34,
				graphics= vComic_NextButtonGraphics,
				font 	= vFontTypeComic,
				hflip 	= true,
				command	= function() 
					gComicPage = gComicPage + 1;
					SwapToModal("scripts/comics.lua"); 
				end;
			},
			AddComicText(),
		},		
		
		Window
		{
			x	= kCenter,
			y	= kCenter,
			w	= kMax,
			h	= kMax,
			name= "middle",
			
			SetStyle(ButtonStyle),
			Button
			{
				--label 	= "prev",
				x		= 5, 
				y		= kMax-34,
				font 	= vFontTypeComic,
				graphics= vComic_PrevButtonGraphics,
				command = function() 
					gComicPage = gComicPage - 1;
					SwapToModal("scripts/comics.lua"); 
				end;
			},
			SetStyle(ButtonStyle),
			Button
			{
				label 	= "skip",
				x		= kCenter, 
				y		= kMax-28,
				font 	= vFontTypeComic,
				graphics= vComic_SkipButtonGraphics,
				command	= function()
					SwapToModal("scripts/loading.lua");
					--SwapToModal("scripts/metamap.lua"); 
				end;
			},
			SetStyle(ButtonStyle),
			Button
			{
				--label	= "next",
				x		= kMax-34,
				y		= kMax-34,
				font 	= vFontTypeComic,
				graphics= vComic_NextButtonGraphics,
				hflip 	= true,
				command	= function() 
					gComicPage = gComicPage + 1;
					SwapToModal("scripts/comics.lua"); 
				end;
			},
			AddComicText(),
		},	
		
		
		Window
		{
			x	= kCenter,
			y	= kCenter,
			w	= kMax,
			h	= kMax,
			name= "last",
			
			SetStyle(ButtonStyle),
			Button
			{
				--label	= "prev",
				x		= 5,
				y		= kMax-34,
				font 	= vFontTypeComic,
				graphics= vComic_PrevButtonGraphics,
				command	= function() 
					gComicPage = gComicPage - 1;
					SwapToModal("scripts/comics.lua"); 
				end;
			},
			SetStyle(ButtonStyle),
			Button
			{
				label	= "play",
				x		= kCenter - 50, 
				y		= kMax-28,
				font 	= vFontTypeComic,
				graphics= vComic_PlayButtonGraphics,
				command	= function()
					SwapToModal("scripts/loading.lua");
					--SwapToModal("scripts/metamap.lua"); 
				end;
			},
			AddComicText(),
		},
		
		Window
		{
			x	= kCenter,
			y	= kCenter,
			w	= kMax,
			h	= kMax,
			name= "one",
			SetStyle(ButtonStyle),
			graphics = vComic_PlayButtonGraphics,
			
			Button
			{
				label	= "play",
				x 		= kCenter-50,
				y		= kMax-28,
				font 	= vFontTypeComic,
				graphics= vComic_PlayButtonGraphics,
				command	= function()
					SwapToModal("scripts/loading.lua");
					--SwapToModal("scripts/metamap.lua"); 
				end;
			},
			AddComicText(),
		},
		
		Window
		{
			x	= kCenter,
			y	= kCenter,
			w	= kMax,
			h	= kMax,
			name= "final",
			SetStyle(ButtonStyle),
			graphics = vComic_PlayButtonGraphics,
			
			Button
			{
				label	= "returntomap",
				x 		= kCenter+150,
				y		= kMax-28,
				font 	= vFontTypeComic,
				graphics= vComic_LongButtonGraphics,
				command	= function()
					SwapToModal("scripts/metamap.lua"); 
				end;
			},
			
			Button
			{
				label	= "mainmenu",
				x 		= kCenter+310,
				y		= kMax-28,
				font 	= vFontTypeComic,
				graphics= vComic_PlayButtonGraphics,
				command	= function()
					SwapToModal("scripts/welcome.lua"); 
				end;
			},
			
			AddComicText(),
		},
		
	},
}
	
SetScreen();
	







